#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include "FileFindForm1.h"

int cmp(unsigned char *buf, unsigned char *target, int size);
unsigned char hstr_i(char *cptr);
void find(char *filename);

unsigned char hstr_i(char *cptr)
{
	unsigned int i, j = 0;
	int k;
	
	for(k = 0;k < 2;k++)
    {
		i = *cptr++ - '0';
		if (9 < i)
			i -= 7;
		j <<= 4;
		j |= (i & 0x0f);
	}
	return (unsigned char) j;
}

void find(char *filename, unsigned char *target, int size)
{
	FILE *fp;
	unsigned char *buf;
	int c;
	long pos, location;
	int found;
	int match = 0;
	char report[50];

	fp = fopen(filename, "rb");
	if(!fp)
	{
		FileFindForm->ResultsList->Items->Add("    Error opening file");
		return;
    }

	buf = (unsigned char *) malloc(size);

	while((c = fgetc(fp)) != EOF)
	{
		if(c == target[0])
		{
			pos = ftell(fp);
			ungetc(c, fp);
			Application->ProcessMessages();
			fread(buf, size, 1, fp);
			{
				found = cmp(buf, target, size);

				if(found == 1)
				{
					if(match == 0)
        			{
						FileFindForm->ResultsList->Items->Add(filename);
    	                match = 1;
                    }
					location = (ftell(fp) - size);
					sprintf(report, "    Found at: %Xh", location);
					FileFindForm->ResultsList->Items->Add(report);
				}
				else
					fseek(fp, pos, SEEK_SET);
			}
		}
	}
	fclose(fp);
	free(buf);
}

int cmp(unsigned char *buf, unsigned char *targ, int size)
{
	int j = 0;
	while(j++ < size)
		if(*buf++ != *targ++) return 0;
	return 1;
}